#!/bin/bash

# Check if Node.js is installed
if ! command -v node &> /dev/null; then
  echo "Node.js is not installed. Please install it from https://nodejs.org/en/download and try again."
  read -p "Press any key to exit..."
  exit 1
fi

# Navigate to the directory of the script
cd "$(dirname "$0")"

# Remove package.json if it exists
if [ -f package.json ]; then
  echo "Removing existing package.json..."
  rm package.json
fi

# Check if package.json exists
if [ ! -f package.json ]; then
  echo "Creating package.json..."
  cat <<EOF > package.json
{
  "name": "dbd-nexus-daemon",
  "version": "1.0.0",
  "description": "",
  "main": "./bot/index",
  "dependencies": {
    "@defaultsbotdevelopment/dbd-tools": "^2.3.3",
    "better-sqlite3": "^11.2.1",
    "chalk": "^4.1.2",
    "discord.js": "^14.15.3",
    "dotenv": "^16.4.5",
    "gamedig": "^5.1.2",
    "knex": "^3.1.0",
		"node-cron": "^3.0.3",
    "node-fetch": "^2.7.0",
		"rcon-srcds": "^2.1.0",
		"systeminformation": "^5.23.5",
    "zod": "^3.23.8"
  }
}
EOF
fi

# Run npm install and start the application
npm install && node ./bot/index.js
