#pragma once

#include "Base.h"

namespace TokenBank::Tokens
{
	void Load();
	void Unload();

	/**
	* \brief Add Tokens to the specific player
	* \param amount Amount of Tokens to add
	* \param eos_id Players eos id
	* \return True if success, false otherwise
	*/
	TOKENBANK_API bool AddTokens(int amount, const FString& eos_id, std::string type);

	/**
	* \brief Subtracts Tokens from the specific player
	* \param amount Amount of Tokens
	* \param eos_id Players eos id
	* \return True if success, false otherwise
	*/
	TOKENBANK_API bool SpendTokens(int amount, const FString& eos_id, std::string type);

	/**
	* \brief Receives Tokens from the specific player
	* \param eos_id Players eos id
	* \return Amount of Tokens the player has for the specific token type
	*/
	TOKENBANK_API int GetTokens(const FString& eos_id, std::string type);

	/**
	* \brief Receives Tokenstypes from the specific player
	* \param eos_id Players eos id
	* \return Amount of Tokens the player has
	*/
	TOKENBANK_API TArray<FString> GetAllTokensType(const FString& eos_id);

	/**
	* \brief Receives Tokens spent from the specific player
	* \param eos_id Players eos id
	* \return Amount of Tokens spent from specific token type
	*/
	TOKENBANK_API int GetTotalSpentTokens(const FString& eos_id, std::string type);

	/**
	* \brief Change Tokens amount for the specific player
	* \param eos_id Players eos id
	* \param new_amount New amount of Tokens
	* \return True if success, false otherwise
	*/
	TOKENBANK_API bool SetTokens(const FString& eos_id, int new_amount, std::string type);


} // namespace Tokens // namespace TokenBank
