import asyncio
import requests
import json
import time
from valve.rcon import RCON
from error_log import log_error  # Importiere die Funktion aus der error_log.py-Datei

# Hier Player-IDs und deren letzte Aktivitätszeit speichern
player_activity = {}

# Lade die Konfigurationszeit, Discord-Webhook-Informationen und Kick-Nachricht aus der config.json-Datei
def load_config():
    try:
        with open("config.json", "r") as config_file:
            config = json.load(config_file)
            config_section = config.get("[RconCommands]", {})
            return (
                config_section.get("kick_time_minutes", 30) * 60,
                config_section.get("discord_webhook_url", ""),
                config_section.get("discord_log_message", "Log-Nachricht"),
                config_section.get("kick_message", ),
                config_section.get("rcon_host", "localhost"),
                config_section.get("rcon_port", 27015),
                config_section.get("rcon_password", ""),
                config_section.get("server_api_url", "http://dein_server_ip:port/players")
            )
    except FileNotFoundError:
        return 30 * 60, "", "Log-Nachricht", "Du wurdest wegen Inaktivität gekickt.", "localhost", 27015, "", "http://dein_server_ip:port/players"

# Funktion zum Senden von RCON-Befehlen
def send_rcon_command(command):
    rcon_host, rcon_port, rcon_password = load_config()
    with RCON((rcon_host, rcon_port), rcon_password) as rcon:
        response = rcon.execute(command)
        return response

# Funktion zum Neustarten des Servers
def restart_server():
    response = send_rcon_command("broadcast Server is restarting!")
    if response: 
        response = send_rcon_command("saveworld")
        response = send_rcon_command("doexit") 
        response = send_rcon_command("start ark-dedicated")
        response = send_rcon_command("Shootergame.exe")
        return "Server is restarting..."
    else:
        return "Fehler beim Neustarten des Servers."

# Funktion zum Kicken eines Spielers
def kick_player(player_name):
    command = f"kick {player_name}"
    response = send_rcon_command(command)
    return response

# Funktion zum Bannen eines Spielers
def ban_player(player_name):
    command = f"ban {player_name}"
    response = send_rcon_command(command)
    return response

# Funktion zum Ändern der Harvest-Raten
def change_harvest_rates(rates):
    command = f"harvesting={rates}"
    response = send_rcon_command(command)
    return response

# Funktion zum Senden der Message of the Day
def send_motd(message):
    command = f"broadcast {message}"
    response = send_rcon_command(command)
    return response

# Funktion zum Loggen von Fehlern
def log_to_discord(message):
    _, discord_webhook_url, _ = load_config()
    if discord_webhook_url:
        payload = {"content": message}
        response = requests.post(discord_webhook_url, json=payload)
        if response.status_code == 204:
            print("Log erfolgreich an Discord gesendet.")
        else:
            print("Fehler beim Senden des Logs an Discord.")
            log_error("Fehler beim Senden des Logs an Discord.")

# Funktion, um Spieler zu kicken
async def kick_inactive_players():
    (
        kick_time, _, _, kick_message, 
        rcon_host, rcon_port, rcon_password, 
        server_api_url
    ) = load_config()
    
    while True:
        try:
            response = requests.get(server_api_url)
            player_list = response.json()

            for player in player_list:
                player_id = player["UniqueId"]
                player_name = player["Name"]

                if player_id in player_activity:
                    last_activity = player_activity[player_id]
                    current_activity = player["LastActiveTime"]

                    if current_activity == last_activity:
                        # Spieler ist inaktiv, Zeit bis zum Kicken prüfen
                        if current_activity + kick_time <= time.time():
                            print(f"Kicke {player_name} wegen Inaktivität")
                            log_to_discord(f"Spieler {player_name} wurde wegen Inaktivität gekickt.")
                            kick_player(player_name)

                    player_activity[player_id] = player["LastActiveTime"]

        except Exception as e:
            error_message = f"Fehler beim Ausführen des Skripts: {str(e)}"
            print(error_message)
            log_error(error_message)

        await asyncio.sleep(kick_time)

loop = asyncio.get_event_loop()
loop.create_task(kick_inactive_players())
loop.run_forever()


async def console_update():
    while True:
        print("Plugin läuft noch...")
        await asyncio.sleep(30)


# ... (Vorheriger Code)

# Funktion zum Ändern der Tageszeit (DayTime)
def change_day_time(time_value):
    command = f"DayTime {time_value}"
    response = send_rcon_command(command)
    return response

# ... (Restlicher Code)

# Funktion, um Spieler zu kicken
async def kick_inactive_players():
    # ...

# Funktion zum regelmäßigen Konsolen-Update
async def console_update():
    while True:
        print("Plugin läuft noch...")
        await asyncio.sleep(30)

# Funktion zum Starten des Plugins
def start_plugin():
    loop = asyncio.get_event_loop()
    loop.create_task(kick_inactive_players())
    loop.create_task(console_update())
    loop.run_forever()

start_plugin()
